<?php

    /**
    *
    * copyright (c) 2015-2017 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    * 
    * Classe che restituisce i link destinati per effettuare la condivisione sui social network
    *
    */

    class SocialSharer {
        public static function facebook($link) {
            $linkCondiviso = urlencode($link);
            return "https://facebook.com/sharer/sharer.php?u=$linkCondiviso";	
	}

	public static function twitter($link,$testo) {
            $linkCondiviso = urlencode($link);
            $testoCondiviso = urlencode($testo);
            return "https://twitter.com/share?url=$linkCondiviso&text=$testoCondiviso";	
	}

	public static function linkedin($link) {
            $linkCondiviso = urlencode($link);
            return "https://www.linkedin.com/shareArticle?mini=true&url=$linkCondiviso";	
	}

	public static function whatsapp($link,$testo) {
            $linkCondiviso = urlencode($link);
            $testoCondiviso = urlencode($testo);
            return "whatsapp://send?text=$linkCondiviso $testoCondiviso";	
	}

        public static function telegram($link,$testo) {
            $linkCondiviso = urlencode($link);
            $testoCondiviso = urlencode($testo);
            return "https://telegram.me/share/url?url=$linkCondiviso&text=$testoCondiviso";	
	}
        
	public static function pinterest($link) {
            $linkCondiviso = urlencode($link);
            return "https://pinterest.com/pin/create/bookmarklet/?&url=$linkCondiviso";	
	}

    }
